#!/bin/bash

#
# LS-R902 version up shell
# @return success: 0, failed: not 0
#
# Lsr902.XXX.tar.gzを展開し
# /opt/CSMVersions/tmp/CSMRoot.XXX/versionup.sh
# 配置された状態で実行されることを前提とする
#

DIR=`dirname "${0}"`

# versionup.sh配置ディレクトリ名
MY_SCRIPT_DEPLOY_PATH=`echo $(cd $(dirname $0) && pwd)`

# versionup.sh配置ディレクトリ名 （末尾のみ）
MY_SCRIPT_DEPLOY_DIRECTORY_NAME=`echo $(cd $(dirname $0) && echo ${PWD##*/})`

# 現在のバージョンのディレクトリ名
CURRENT_VERSION_PATH="/opt/CSMRoot"

# 現在のバージョンの設定ファイルディレクトリ名(old)
OLD_CURRENT_VERSION_SETTINGS_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR900/Setdata"

# 現在のバージョンの設定ファイルディレクトリ名
CURRENT_VERSION_SETTINGS_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/Setdata"

# コピー先の設定ファイルディレクトリ名
MY_VERSION_SETTINGS_PATH="${MY_SCRIPT_DEPLOY_PATH}/Storage Card/LSR902/Setdata"

# 現在のバージョンのATCディレクトリ名
CURRENT_VERSION_ATC_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/Atc"

# コピー先のATCディレクトリ名
MY_VERSION_ATC_PATH="${MY_SCRIPT_DEPLOY_PATH}/Storage Card/LSR902/Atc"

# 現在のバージョンのManualディレクトリ名
CURRENT_VERSION_MANUAL_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/Etc"

# コピー先のManualディレクトリ名
MY_VERSION_MANUAL_PATH="${MY_SCRIPT_DEPLOY_PATH}/Storage Card/LSR902/Etc"

# 現在のバージョンのBDTファイル名
CURRENT_VERSION_00BDT_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/SBU00.BDT"
CURRENT_VERSION_01BDT_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/SBU01.BDT"
CURRENT_VERSION_02BDT_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/SBU02.BDT"
CURRENT_VERSION_03BDT_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/SBU03.BDT"
CURRENT_VERSION_04BDT_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/SBU04.BDT"
CURRENT_VERSION_05BDT_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/SBU05.BDT"
CURRENT_VERSION_06BDT_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/SBU06.BDT"
CURRENT_VERSION_07BDT_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/SBU07.BDT"
CURRENT_VERSION_08BDT_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/SBU08.BDT"
CURRENT_VERSION_09BDT_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/SBU09.BDT"
CURRENT_VERSION_0ABDT_PATH="${CURRENT_VERSION_PATH}/Storage Card/LSR902/SBU0A.BDT"

# コピー先のBDTディレクトリ名
MY_VERSION_BDT_PATH="${MY_SCRIPT_DEPLOY_PATH}/Storage Card/LSR902/"
# コピー先のBDTファイル名
MY_VERSION_00BDT_PATH="${MY_SCRIPT_DEPLOY_PATH}/Storage Card/LSR902/SBU00.BDT"


# バージョン格納ディレクトリ名
VERSIONS_PATH="/opt/CSMVersions"

# 最大バージョン
MAX_VERSION_COUNT=3

# 復元フラグ
RESTORE=0
if [ $# -eq 1 ]; then
  if [ $1 = "restore" ]; then
    RESTORE=1
  fi
fi


###############
# debug print #
###############
function debug_print() {
  log_debug "MY_SCRIPT_DEPLOY_PATH:           ${MY_SCRIPT_DEPLOY_PATH}"
  log_debug "MY_SCRIPT_DEPLOY_DIRECTORY_NAME: ${MY_SCRIPT_DEPLOY_DIRECTORY_NAME}"
  log_debug "CURRENT_VERSION_PATH:            ${CURRENT_VERSION_PATH}"
  log_debug "CURRENT_VERSION_SETTINGS_PATH:   ${CURRENT_VERSION_SETTINGS_PATH}"
  log_debug "CURRENT_VERSION_ATC_PATH:        ${CURRENT_VERSION_ATC_PATH}"
  log_debug "MY_VERSION_SETTINGS_PATH:        ${MY_VERSION_SETTINGS_PATH}"
  log_debug "VERSIONS_PATH:                   ${VERSIONS_PATH}"
  log_debug "MAX_VERSION_COUNT:               ${MAX_VERSION_COUNT}"
}

########################################
# logger error message
# @param arg1 error message
########################################
function log_debug(){
  echo "debug:" $1
}

########################################
# logger error message
# @param arg1 error message
########################################
function log_info(){
  echo "info :" $1
}

########################################
# logger error message
# @param arg1 error message
########################################
function log_error(){
  echo "error:" $1
}

########################################
# setting files copy
########################################
function copy_settings() {
  log_debug "called copy_settings"

  # コピー元チェック
  if [ -d "${CURRENT_VERSION_SETTINGS_PATH}" ];then
    log_info "found current setting directory. ${CURRENT_VERSION_SETTINGS_PATH}"
  else
    if [ -d "${OLD_CURRENT_VERSION_SETTINGS_PATH}" ];then
      CURRENT_VERSION_SETTINGS_PATH=${OLD_CURRENT_VERSION_SETTINGS_PATH}
      log_info "found current setting directory(old). ${CURRENT_VERSION_SETTINGS_PATH}"
    else
      log_error "not found current setting directory. ${CURRENT_VERSION_SETTINGS_PATH}"
      exit -1
    fi
  fi

  # コピー先チェック
  if [ -e "${MY_VERSION_SETTINGS_PATH}" ];then
    log_info "found my setting directory. ${MY_VERSION_SETTINGS_PATH}"
    # コピー先にファイル、またはディレクトリが存在する場合は削除する
    log_info "remove my setting directory. ${MY_VERSION_SETTINGS_PATH}"
    rm -rf "${MY_VERSION_SETTINGS_PATH}"
    if [ $? -ne 0 ]; then
      # コピー先ファイル、またはディレクトリの削除に失敗した場合、終了する
      log_error "failed remove my setting directory. ${MY_VERSION_SETTINGS_PATH}"
      exit -1
    fi
  else
    log_info "not found my setting directory. ${MY_VERSION_SETTINGS_PATH}"
  fi

  # コピー実施
  log_info "copy setting directory. from: ${CURRENT_VERSION_SETTINGS_PATH}, to: ${MY_VERSION_SETTINGS_PATH}"
  cp -pr "${CURRENT_VERSION_SETTINGS_PATH}" "${MY_VERSION_SETTINGS_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、終了する
    log_error "failed copy setting directory. ${MY_VERSION_SETTINGS_PATH}"
    exit -1
  fi
}

########################################
# atc files copy
########################################
function copy_atc() {
  log_debug "called copy_atc"

  # コピー元チェック
  if [ -d "${CURRENT_VERSION_ATC_PATH}" ];then
    log_info "found current atc directory. ${CURRENT_VERSION_ATC_PATH}"
  else
    log_error "not found current atc directory. ${CURRENT_VERSION_ATC_PATH}"
    return
  fi

  # コピー先チェック
  if [ -e "${MY_VERSION_ATC_PATH}" ];then
    log_info "found my atc directory. ${MY_VERSION_ATC_PATH}"
    # コピー先にファイル、またはディレクトリが存在する場合は削除する
    log_info "remove my atc directory. ${MY_VERSION_ATC_PATH}"
    rm -rf "${MY_VERSION_ATC_PATH}"
    if [ $? -ne 0 ]; then
      # コピー先ファイル、またはディレクトリの削除に失敗した場合、終了する
      log_error "failed remove my atc directory. ${MY_VERSION_ATC_PATH}"
      exit -1
    fi
  else
    log_info "not found my atc directory. ${MY_VERSION_ATC_PATH}"
  fi

  # コピー実施
  log_info "copy atc directory. from: ${CURRENT_VERSION_ATC_PATH}, to: ${MY_VERSION_ATC_PATH}"
  cp -pr "${CURRENT_VERSION_ATC_PATH}" "${MY_VERSION_ATC_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、終了する
    log_error "failed copy atc directory. ${MY_VERSION_ATC_PATH}"
    exit -1
  fi
}

########################################
# manual files copy
########################################
function copy_manual() {
  log_debug "called copy_manual"

  # バージョンアップファイルチェック
  if [ -d "${MY_VERSION_MANUAL_PATH}" ];then
    log_info "found my manual directory. ${MY_VERSION_MANUAL_PATH}"
    return
  else
    log_error "not found my manual directory. ${MY_VERSION_MANUAL_PATH}"
  fi

  # 現在のバージョンをチェック
  if [ -e "${CURRENT_VERSION_MANUAL_PATH}" ];then
    log_info "found current manual directory. ${CURRENT_VERSION_MANUAL_PATH}"
  else
    log_info "not found current manual directory. ${CURRENT_VERSION_MANUAL_PATH}"
    return
  fi

  # コピー実施
  log_info "copy manual directory. from: ${CURRENT_VERSION_MANUAL_PATH}, to: ${MY_VERSION_MANUAL_PATH}"
  cp -pr "${CURRENT_VERSION_MANUAL_PATH}" "${MY_VERSION_MANUAL_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、終了する
    log_error "failed copy manual directory. ${MY_VERSION_MANUAL_PATH}"
    exit -1
  fi
}

########################################
# bdt files copy
########################################
function copy_bdt() {
  log_debug "called copy_bdt"

  # バージョンアップファイルチェック
  if [ -f "${MY_VERSION_00BDT_PATH}" ];then
    log_info "found my sbu00.bdt file. ${MY_VERSION_00BDT_PATH}"
    return
  else
    log_error "not found my sbu00.bdt file. ${MY_VERSION_00BDT_PATH}"
  fi

  # 現在のバージョンをチェック
  if [ -e "${CURRENT_VERSION_00BDT_PATH}" ];then
    log_info "found current bdt file. ${CURRENT_VERSION_00BDT_PATH}"
  else
    log_info "not found current bdt file. ${CURRENT_VERSION_00BDT_PATH}"
    return
  fi

  # コピー実施0
  log_info "copy bdt file. from: ${CURRENT_VERSION_00BDT_PATH}, to: ${MY_VERSION_BDT_PATH}"
  cp -pr "${CURRENT_VERSION_00BDT_PATH}" "${MY_VERSION_BDT_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、終了する
    log_error "failed copy sbu00.bdt file. ${MY_VERSION_BDT_PATH}"
    exit -1
  fi

  # コピー実施1
  log_info "copy bdt file. from: ${CURRENT_VERSION_01BDT_PATH}, to: ${MY_VERSION_BDT_PATH}"
  cp -pr "${CURRENT_VERSION_01BDT_PATH}" "${MY_VERSION_BDT_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、ファイルを削除して終了する
	rm "${CURRENT_VERSION_00BDT_PATH}"
    log_error "failed copy sbu01.bdt file. ${CURRENT_VERSION_01BDT_PATH}"
    exit -1
  fi

  # コピー実施2
  log_info "copy bdt file. from: ${CURRENT_VERSION_02BDT_PATH}, to: ${MY_VERSION_BDT_PATH}"
  cp -pr "${CURRENT_VERSION_02BDT_PATH}" "${MY_VERSION_BDT_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、ファイルを削除して終了する
	rm "${CURRENT_VERSION_00BDT_PATH}"
	rm "${CURRENT_VERSION_01BDT_PATH}"
    log_error "failed copy sbu02.bdt file. ${CURRENT_VERSION_02BDT_PATH}"
    exit -1
  fi

  # コピー実施3
  log_info "copy bdt file. from: ${CURRENT_VERSION_03BDT_PATH}, to: ${MY_VERSION_BDT_PATH}"
  cp -pr "${CURRENT_VERSION_03BDT_PATH}" "${MY_VERSION_BDT_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、ファイルを削除して終了する
	rm "${CURRENT_VERSION_00BDT_PATH}"
	rm "${CURRENT_VERSION_01BDT_PATH}"
	rm "${CURRENT_VERSION_02BDT_PATH}"
    log_error "failed copy sbu03.bdt file. ${CURRENT_VERSION_03BDT_PATH}"
    exit -1
  fi

  # コピー実施4
  log_info "copy bdt file. from: ${CURRENT_VERSION_04BDT_PATH}, to: ${MY_VERSION_BDT_PATH}"
  cp -pr "${CURRENT_VERSION_04BDT_PATH}" "${MY_VERSION_BDT_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、ファイルを削除して終了する
	rm "${CURRENT_VERSION_00BDT_PATH}"
	rm "${CURRENT_VERSION_01BDT_PATH}"
	rm "${CURRENT_VERSION_02BDT_PATH}"
	rm "${CURRENT_VERSION_03BDT_PATH}"
    log_error "failed copy sbd04.bdt file. ${CURRENT_VERSION_04BDT_PATH}"
    exit -1
  fi

  # コピー実施5
  log_info "copy bdt file. from: ${CURRENT_VERSION_05BDT_PATH}, to: ${MY_VERSION_BDT_PATH}"
  cp -pr "${CURRENT_VERSION_05BDT_PATH}" "${MY_VERSION_BDT_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、ファイルを削除して終了する
	rm "${CURRENT_VERSION_00BDT_PATH}"
	rm "${CURRENT_VERSION_01BDT_PATH}"
	rm "${CURRENT_VERSION_02BDT_PATH}"
	rm "${CURRENT_VERSION_03BDT_PATH}"
	rm "${CURRENT_VERSION_04BDT_PATH}"
    log_error "failed copy sbu05.bdt file. ${CURRENT_VERSION_05BDT_PATH}"
    exit -1
  fi

  # コピー実施6
  log_info "copy bdt file. from: ${CURRENT_VERSION_06BDT_PATH}, to: ${MY_VERSION_BDT_PATH}"
  cp -pr "${CURRENT_VERSION_06BDT_PATH}" "${MY_VERSION_BDT_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、ファイルを削除して終了する
	rm "${CURRENT_VERSION_00BDT_PATH}"
	rm "${CURRENT_VERSION_01BDT_PATH}"
	rm "${CURRENT_VERSION_02BDT_PATH}"
	rm "${CURRENT_VERSION_03BDT_PATH}"
	rm "${CURRENT_VERSION_04BDT_PATH}"
	rm "${CURRENT_VERSION_05BDT_PATH}"
    log_error "failed copy sbu06.bdt file. ${CURRENT_VERSION_06BDT_PATH}"
    exit -1
  fi

  # コピー実施7
  log_info "copy bdt file. from: ${CURRENT_VERSION_07BDT_PATH}, to: ${MY_VERSION_BDT_PATH}"
  cp -pr "${CURRENT_VERSION_07BDT_PATH}" "${MY_VERSION_BDT_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、ファイルを削除して終了する
	rm "${CURRENT_VERSION_00BDT_PATH}"
	rm "${CURRENT_VERSION_01BDT_PATH}"
	rm "${CURRENT_VERSION_02BDT_PATH}"
	rm "${CURRENT_VERSION_03BDT_PATH}"
	rm "${CURRENT_VERSION_04BDT_PATH}"
	rm "${CURRENT_VERSION_05BDT_PATH}"
	rm "${CURRENT_VERSION_06BDT_PATH}"
    log_error "failed copy sbu07.bdt file. ${CURRENT_VERSION_07BDT_PATH}"
    exit -1
  fi

  # コピー実施8
  log_info "copy bdt file. from: ${CURRENT_VERSION_08BDT_PATH}, to: ${MY_VERSION_BDT_PATH}"
  cp -pr "${CURRENT_VERSION_08BDT_PATH}" "${MY_VERSION_BDT_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、ファイルを削除して終了する
	rm "${CURRENT_VERSION_00BDT_PATH}"
	rm "${CURRENT_VERSION_01BDT_PATH}"
	rm "${CURRENT_VERSION_02BDT_PATH}"
	rm "${CURRENT_VERSION_03BDT_PATH}"
	rm "${CURRENT_VERSION_04BDT_PATH}"
	rm "${CURRENT_VERSION_05BDT_PATH}"
	rm "${CURRENT_VERSION_06BDT_PATH}"
	rm "${CURRENT_VERSION_07BDT_PATH}"
    log_error "failed copy sbu08.bdt file. ${CURRENT_VERSION_08BDT_PATH}"
    exit -1
  fi

  # コピー実施9
  log_info "copy bdt file. from: ${CURRENT_VERSION_09BDT_PATH}, to: ${MY_VERSION_BDT_PATH}"
  cp -pr "${CURRENT_VERSION_09BDT_PATH}" "${MY_VERSION_BDT_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、ファイルを削除して終了する
	rm "${CURRENT_VERSION_00BDT_PATH}"
	rm "${CURRENT_VERSION_01BDT_PATH}"
	rm "${CURRENT_VERSION_02BDT_PATH}"
	rm "${CURRENT_VERSION_03BDT_PATH}"
	rm "${CURRENT_VERSION_04BDT_PATH}"
	rm "${CURRENT_VERSION_05BDT_PATH}"
	rm "${CURRENT_VERSION_06BDT_PATH}"
	rm "${CURRENT_VERSION_07BDT_PATH}"
	rm "${CURRENT_VERSION_08BDT_PATH}"
    log_error "failed copy sbu09.bdt file. ${CURRENT_VERSION_09BDT_PATH}"
    exit -1
  fi

  # コピー実施A
  log_info "copy bdt file. from: ${CURRENT_VERSION_0ABDT_PATH}, to: ${MY_VERSION_BDT_PATH}"
  cp -pr "${CURRENT_VERSION_0ABDT_PATH}" "${MY_VERSION_BDT_PATH}"
  if [ $? -ne 0 ]; then
    # コピーに失敗した場合、ファイルを削除して終了する
	rm "${CURRENT_VERSION_00BDT_PATH}"
	rm "${CURRENT_VERSION_01BDT_PATH}"
	rm "${CURRENT_VERSION_02BDT_PATH}"
	rm "${CURRENT_VERSION_03BDT_PATH}"
	rm "${CURRENT_VERSION_04BDT_PATH}"
	rm "${CURRENT_VERSION_05BDT_PATH}"
	rm "${CURRENT_VERSION_06BDT_PATH}"
	rm "${CURRENT_VERSION_07BDT_PATH}"
	rm "${CURRENT_VERSION_08BDT_PATH}"
	rm "${CURRENT_VERSION_09BDT_PATH}"
    log_error "failed copy sbu0a.bdt file. ${CURRENT_VERSION_0ABDT_PATH}"
    exit -1
  fi
}

########################################
# increment version directories
########################################
function increment_versions() {
  log_debug "called increment_versions"

  VERSION_GENERATION=`expr ${MAX_VERSION_COUNT} - 1`
  log_info "remove max version. ${VERSIONS_PATH}/${VERSION_GENERATION}"
  rm -rf "${VERSIONS_PATH}/${VERSION_GENERATION}"
  if [ $? -ne 0 ]; then
    # rmに失敗した場合、終了する
    log_error "failed remove. ${VERSIONS_PATH}/${VERSION_GENERATION}"
    exit -1
  fi

  # mv version
  while [ ${VERSION_GENERATION} -gt 0 ]; do
    VERSION_GENERATION_FROM=`expr ${VERSION_GENERATION} - 1`

    if [ ! -e ${VERSIONS_PATH}/${VERSION_GENERATION_FROM} ]; then
      # コピー元ディレクトリが存在しない場合はスキップする
      # count up
      VERSION_GENERATION=`expr ${VERSION_GENERATION} - 1`
      continue
    fi

    log_info "move version. from: ${VERSIONS_PATH}/${VERSION_GENERATION_FROM} to: ${VERSION_GENERATION}"

    mv "${VERSIONS_PATH}/${VERSION_GENERATION_FROM}" "${VERSIONS_PATH}/${VERSION_GENERATION}"
    if [ $? -ne 0 ]; then
      # mvに失敗した場合、終了する
      log_error "failed move. from: ${VERSIONS_PATH}/${VERSION_GENERATION_FROM} to: ${VERSION_GENERATION}"
      exit -1
    fi
    
    # count up
    VERSION_GENERATION=`expr ${VERSION_GENERATION} - 1`
  done

  # mv version "tmp -> version 0"
  log_info "move version. from: ${VERSIONS_PATH}/tmp to: 0"
  mv "${VERSIONS_PATH}/tmp" "${VERSIONS_PATH}/0"
  if [ $? -ne 0 ]; then
    # mvに失敗した場合、終了する
    log_info "failed move. from: ${VERSIONS_PATH}/tmp to: 0"
    exit -1
  fi
}

########################################
# make symbolic link
########################################
function make_symbolik_link(){
  log_debug "called make_symbolik_link"

  # unlink
  log_info "unlink ${CURRENT_VERSION_PATH}"
  unlink "${CURRENT_VERSION_PATH}"
  if [ $? -ne 0 ]; then
    # unlinkに失敗した場合、終了する
    log_error "failed unlink directory. ${CURRENT_VERSION_PATH}"
    exit -1
  fi

  # link
  log_info "link from: ${VERSIONS_PATH}/0/${MY_SCRIPT_DEPLOY_DIRECTORY_NAME}, to: ${CURRENT_VERSION_PATH}"
  ln -s "${VERSIONS_PATH}/0/${MY_SCRIPT_DEPLOY_DIRECTORY_NAME}" "${CURRENT_VERSION_PATH}"
  if [ $? -ne 0 ]; then
    # linkに失敗した場合、終了する
    log_error "failded link. from: ${VERSIONS_PATH}/0/${MY_SCRIPT_DEPLOY_DIRECTORY_NAME}, to: ${CURRENT_VERSION_PATH}"
    exit -1
  fi
}

########################################
# remove old versions
########################################
function remove_old_versions() {
  log_debug "called remove_old_versions"
  VERSION_DIRECTORIES=`echo $(cd ${VERSIONS_PATH} && echo $(ls | egrep -e "^[0-9]+$" | sort -n))`
  log_debug "versions: ${VERSION_DIRECTORIES}"
  for VERSION_DIRECTORY in ${VERSION_DIRECTORIES}
  do
    log_debug "version: ${VERSION_DIRECTORY}"
    if [ ${VERSION_DIRECTORY} -ge ${MAX_VERSION_COUNT} ]; then
      log_debug "version is over. remove: ${VERSIONS_PATH}/${VERSION_DIRECTORY}"
      rm -rf ${VERSIONS_PATH}/${VERSION_DIRECTORY}
      if [ $? -ne 0 ]; then
        # linkに失敗した場合、終了する
        log_error "failed remove: ${VERSIONS_PATH}/${VERSION_DIRECTORY}"
        exit -1
      fi
    fi
  done
}

# debug print
debug_print

# setting files copy
if [ ${RESTORE} -eq 0 ]; then
  copy_settings
fi

# atc files copy
if [ ${RESTORE} -eq 0 ]; then
  copy_atc
fi

# manual files copy
copy_manual

# memory backup files copy
copy_bdt

# increment version directories
increment_versions

# make symbolic link
make_symbolik_link

# remove old versions
remove_old_versions

# for test
#log_error "test error"

# version up file system
# execute versionup_rootfsXXX.sh
cd ${DIR}/versionup

./versionup_rootfs.sh

if [ -e ./versionup_rootfs_fonts.sh ]; then
  ./versionup_rootfs_fonts.sh
fi

if [ -e ./versionup_kernel.sh ]; then
  ./versionup_kernel.sh
fi

# sync
sync

# return success
exit 0
