#!/bin/sh

# check linux process
# for SecondApp
SECOND_APP=`pgrep -fl SecondApp | wc -l`
# for WombitMiscellaneousSetting
WOMBIT=`pgrep -fl WombitMiscellaneousSetting | wc -l`
# for Lsr901Display
LSR901_DISPLAY=`pgrep -fl Lsr901Display | grep -v monitor | wc -l`

echo ${SECOND_APP}
echo ${WOMBIT}
echo ${LSR901_DISPLAY}

if [ "${SECOND_APP}" = "0" ]; then
  echo not found process SecondApp
fi

if [ "${WOMBIT}" = "0" ]; then
  echo not found process WombitMiscellaneousSetting
fi

if [ "${LSR901_DISPLAY}" = "0" ]; then
  echo not found process Lsr901Display
fi


if [ "${SECOND_APP}" = "0" ] || [ "${WOMBIT}" = "0" ] || [ "${LSR901_DISPLAY}" = "0" ]; then
  # error occurred
  exit 255
fi

echo led off
# linux process ok
# cosmo led off
cd /sys/class/gpio
echo 176 > export
cd gpio176
echo out > direction
echo 0 > value
