#!/bin/sh
echo "start $0 **********"

if [ $# -ne 1 ]; then
  echo usage. $0 language_index:int
  exit 0
fi

DIR=`dirname ${0}`

cd ${DIR}


NEXT_LANGUAGE=`expr \( $1 + 1 \) % 7`

echo next language: ${NEXT_LANGUAGE}

case ${NEXT_LANGUAGE} in
  0 ) ./change_language_to_english.sh ;;
  1 ) ./change_language_to_japanese.sh ;;
  2 ) ./change_language_to_chinese.sh ;;
  3 ) ./change_language_to_korean.sh ;;
  4 ) ./change_language_to_german.sh ;;
  5 ) ./change_language_to_spanish.sh ;;
  6 ) ./change_language_to_portuguese.sh ;;
esac

return ${NEXT_LANGUAGE}
