#!/bin/sh

#
# LS-R902 boot shell
#

virtual_etc() {
  mount -t tmpfs -o size=8m tmpfs /mnt
  cp -pr /etc /mnt/virtual_etc
  mount --bind /mnt/virtual_etc /etc
}

versionup() {
  VERSIONUP_FLAG=`ls /run/media/*/CSM_CONF_VERSIONUP | sort | tail -1`
  if [ "${VERSIONUP_FLAG}" != "" ] && [ -e ${VERSIONUP_FLAG} ]; then
    VERSIONUP_FLAG_DIR=`dirname ${VERSIONUP_FLAG}`

    VERSIONUP_TARGZ=`ls ${VERSIONUP_FLAG_DIR}/Lsr902.*.tar.gz | sort | tail -1`
    if [ "${VERSIONUP_TARGZ}" != "" ] && [ -e ${VERSIONUP_TARGZ} ]; then

      # blink LED
      /opt/blink_led.sh &

      rm -rf /opt/CSMVersions/tmp
      mkdir /opt/CSMVersions/tmp
      cd /opt/CSMVersions/tmp

      tar xvf $VERSIONUP_TARGZ

      if [ $? -ne 0 ]; then
        echo failed tar. reboot.
        /usr/bin/pkill blink_led.sh
        /opt/blink_led_for_error.sh &
        sleep 5
        sync
        reboot -f
      fi

      cd Lsr902.*

      ./versionup.sh

      if [ $? -ne 0 ]; then
        echo failed tar. reboot.
        /usr/bin/pkill blink_led.sh
        /opt/blink_led_for_error.sh &
        sleep 5
        sync
        reboot -f
      fi

      DATE=`date +"%Y%m%d_%H%M%S"`
      mv ${VERSIONUP_FLAG} ${VERSIONUP_FLAG}_EXEC_${DATE}
      VERSIONUP_TARGZ_FILENAME=`basename $VERSIONUP_TARGZ`
      echo "version up ${DATE} ${VERSIONUP_TARGZ_FILENAME}" >> ${VERSIONUP_FLAG}_EXEC_${DATE}

      sync
      reboot -f
    fi
  fi
}

# network
ifconfig eth0 up

echo 30000 >  /proc/sys/vm/min_free_kbytes

#virtual_etc
virtual_etc

# qt setting
export TSLIB_TSEVENTTYPE=INPUT
export TSLIB_CONSOLEDEVICE=none
export TSLIB_FBDEVICE=/dev/fb0
export TSLIB_TSDEVICE=/dev/input/event0
export TSLIB_CALIBFILE=/opt/pointercal
export TSLIB_CONFFILE=/etc/ts.conf
export TSLIB_PLUGINDIR=/usr/lib/ts

export QT_QPA_EGLFS_TSLIB=1
export QT_QPA_GENERIC_PLUGINS=tslib

export QT_QPA_PLATFORM=eglfs

export LD_LIBRARY_PATH=\
/opt/CSMRoot/Storage\ Card/LSR902/Prg

# for grabled font
export QML_USE_GLYPHCACHE_WORKAROUND=1

# detect mouse 
USB_MOUSE_COUNT=`cat /proc/bus/input/devices  | tr '\n' ' ' | sed 's/  /\n/g' | grep -i usb | grep mouse | wc -l`
if [ ${USB_MOUSE_COUNT} -eq 0 ];then
  export QT_QPA_EGLFS_DISABLE_INPUT=1
fi

# Do not show console log on console
echo 0 4 1 7 > /proc/sys/kernel/printk

# cpu performance
cpufreq-set -g performance
cpufreq-set -f 792000

# lcd on
#/opt/lcd_on.sh

# check CSM_CONF file
if ls /run/media/*/CSM_CONF_NO_AUTO_START 1> /dev/null 2>&1; then
  echo
  echo COSMO: exist CSM_CONF_NO_AUTO_START
else
  echo
  echo COSMO: Starting LS-R902

  # boot initialize
  if [ -e "/opt/CSMRoot/Storage Card/LSR902/Prg/shells/boot_initialize.sh" ]; then
    # execute initialize
    echo COSMO: exist boot_initialize.sh
    "/opt/CSMRoot/Storage Card/LSR902/Prg/shells/boot_initialize.sh"
  else
    echo COSMO: not exist boot_initialize.sh
  fi

  # versionup
  versionup

  if ls /run/media/*/CSM_CONF_NO_CLEAR_CACHE_AND_BUFFER 1> /dev/null 2>&1; then
    SECONDAPP_OPTIONS="--no-clear-cache-and-buffer"
  fi

  SECONDAPP_OPTIONS="${SECONDAPP_OPTIONS} --startup-first display --startup-span 8000"
  #SECONDAPP_OPTIONS="${SECONDAPP_OPTIONS} --startup-first wombit --startup-span 8000"

  if ls /run/media/*/CSM_CONF_DEVELOP_MODE  1> /dev/null 2>&1; then
    export CSM_CONF_SECONDAPP_ADD_OPTION_STARTUP_LSR901_DISPLAY="--initialize-progressbar-time 3000 --develop-mode"
  else
    export CSM_CONF_SECONDAPP_ADD_OPTION_STARTUP_LSR901_DISPLAY="--initialize-progressbar-time 3000"
  fi

  if ls /run/media/*/CSM_CONF_MUTE_BUZZER 1> /dev/null 2>&1; then
    echo
    echo COSMO: exist CSM_CONF_MUTE_BUZZER
    export CSM_CONF_SECONDAPP_ADD_OPTION_STARTUP_WOMBIT_MISCELLANEOUS_SETTING="--mute"
  fi

  # kernel module setting
  insmod /opt/CSMRoot/spi-fc-slave16.ko

  cd /opt/CSMRoot && \
  ./Storage\ Card/LSR902/Prg/SecondApp ${SECONDAPP_OPTIONS} > /dev/null 2>&1 &

  # monitor memory & Lsr901Display kill
  /opt/CSMRoot/Storage\ Card/LSR902/Prg/shells/monitor_memory_and_Lsr901Display_kill.sh > /dev/null 2>&1 &

  # monitor memory & buff and cache clear
  /opt/CSMRoot/Storage\ Card/LSR902/Prg/shells/monitor_memory_and_clear_buff_cache.sh > /dev/null 2>&1 &

fi

# for test
cd /opt/CSMRoot/Storage\ Card/LSR902/Prg/shells/stress
./stress_check_usb_and_start.sh > /dev/null 2>&1 &

# for test
# boot check and led off
if ls /run/media/*/CSM_CONF_BOOT_CHECK_AND_LED_OFF 1> /dev/null 2>&1; then
  sleep 15
  /opt/check_process_and_led_off.sh
fi

exit 0
