#!/bin/sh

DIR=`dirname "${0}"`
DIR_FULL_PATH="${PWD}/${DIR}"

ROOTFS_RO=`"/opt/CSMRoot/Storage Card/LSR902/Prg/shells/check_rootfs_ro.sh"`
DATE=`date "+%Y%m%d_%H%M%S"`

# rootfs read write
if [ ${ROOTFS_RO} == "ro" ];then
  mount -o rw,remount /
fi

# update startup script
cp -pr $DIR/rootfs/etc/rc.local /etc/rc.local
chown root.root /etc/rc.local

# update profile
# for develop
cp -pr $DIR/rootfs/etc/profile /etc/profile
chown root.root /etc/profile

# update group
cp -pr $DIR/rootfs/etc/group /etc/group
chown root.root /etc/group

# update ts.conf
cp -pr $DIR/rootfs/etc/ts.conf /etc/ts.conf
chown root.root /etc/ts.conf

# update operation shells
cp -pr $DIR/rootfs/opt/*.sh /opt/.
chown root.root /opt/*

# install e2fsck.static
cp -pr $DIR/rootfs/sbin/e2fsck.static /sbin/.
chown root.root /sbin/e2fsck.static

# os version file
if [ -e $DIR/rootfs/etc/cosmoosver/core-image-qt5-imx6solohinoeng.txt ];then
  # バージョンアップファイル内にOSバージョンファイルが存在する場合、
  # OSバージョンファイルを更新する

  # ファイル件数取得
  OS_VER_FILE_COUNT=`ls /etc/cosmoosver/core-image-qt5-imx6solohinoeng.txt* | wc -l`

  if [ ${OS_VER_FILE_COUNT} -eq 1 ];then
    # 1ファイルしかない場合
    # 当該のファイルはオリジナルのOSバージョンファイルのため
    # orgをつけてバックアップを行う
    OS_VER_FILE_SUFFIX="_org"
  fi

  # backup os version file
  #
  # file name: core-image-qt5-imx6solohinoeng.txt_bakYYYYMMDD_hhmmss_org
  # or
  # file name: core-image-qt5-imx6solohinoeng.txt_bakYYYYMMDD_hhmmss
  mv /etc/cosmoosver/core-image-qt5-imx6solohinoeng.txt \
     /etc/cosmoosver/core-image-qt5-imx6solohinoeng.txt_bak${DATE}${OS_VER_FILE_SUFFIX}
  
  # copy new os version file
  cp -pr $DIR/rootfs/etc/cosmoosver/core-image-qt5-imx6solohinoeng.txt /etc/cosmoosver/.
  chown root.root /etc/cosmoosver/core-image-qt5-imx6solohinoeng.txt
fi

# touch pad calibration file
if [ ! -e /opt/pointercal ];then
  cp -pr $DIR/rootfs/opt/pointercal /opt/
  chown root.root /opt/*
fi

# kernel module
unlink /opt/spi-fc.ko
ln -s /opt/spi-fc_test12.ko /opt/spi-fc.ko

# for test shells
cp -pr $DIR/rootfs/opt/clickDisplay /opt/.
chown -R root.root /opt/clickDisplay

# for archives
cd /
for ARCHIVE in `ls $DIR_FULL_PATH/archives/*.tar.gz`; do
  tar zxvf ${ARCHIVE}
done

# for symlink (to qml cache)
if [ ! -L /.cache ];then
  if [ ! -d /opt/.cache ];then
    rm -rf /opt/.cache
    mkdir /opt/.cache
  fi
  rm -rf /.cache
  ln -s /opt/.cache /.cache
fi

# sync filesystem
sync

# rootfs read only
if [ ${ROOTFS_RO} == "ro" ];then
  mount -o ro,remount /
fi
